;*******************************
;*    DEMONTRATION PROGRAM 1   *
;*     LED & LED 7-SEGMENT     *
;*******************************
;
            ORG    8000H
PORTA       EQU    0E0B8H
PORTB       EQU    0E0B9H
PORTC       EQU    0E0BAH
CTRL        EQU    0E0BBH
SEG_PORT    EQU    PORTB
SYSCALL     EQU    0030H

CP3DEM1:    MOV    DPTR,#SEG_PORT
            MOV    R1,DPL
            MOV    DPTR,#CTRL
            MOV    P2,DPH
            MOV    R0,DPL
            MOV    A,#80H
            MOVX   @R0,A         ;Port = P2:R0
            MOV    DPTR,#PORTC
            MOV    R0,DPL

BEGIN:      MOV    R2,#1         ;Start bit moving
            MOV    R3,#0
FORWARD:    MOV    A,R2
            MOVX   @R0,A         ;Out LED
            MOV    B,R3
            MOV    A,#15H
            LCALL  SYSCALL       ;Convert hex to segment
            MOVX   @R1,A         ;Out data to 7-segment
            LCALL  DELAY
            MOV    A,R2
            RL     A             ;Rotate left
            MOV    R2,A
            INC    R3            ;Increase 7-segment display
            MOV    A,R3
            XRL    A,#8
            JNZ    FORWARD
            CLR    A
            MOVX   @R0,A         ;Clear led
            LCALL  DELAY
            LCALL  DELAY
            MOV    R2,#80H

BACKWARD:   MOV    A,R2
            MOVX   @R0,A
            MOV    B,R3
            MOV    A,#15H
            LCALL  SYSCALL
            MOVX   @R1,A         ;Out segment
            LCALL  DELAY
            MOV    A,R2
            RR     A
            MOV    R2,A
            INC    R3
            MOV    A,R3
            XRL    A,#16
            JNZ    BACKWARD
            CLR    A
            MOVX   @R0,A
            MOVX   @R1,A
            LCALL  DELAY
            LCALL  DELAY
            LCALL  DELAY
            SJMP   BEGIN

DELAY:      MOV    DPTR,#2000H
DLY1:       INC    DPTR
            MOV    A,DPH
            ORL    A,DPL
            JNZ    DLY1
            RET

            END

